/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.peers.sip.transaction;

import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import net.sourceforge.peers.Logger;
import net.sourceforge.peers.sip.transaction.NonInviteServerTransactionState;
import net.sourceforge.peers.sip.transaction.NonInviteServerTransactionStateCompleted;
import net.sourceforge.peers.sip.transaction.NonInviteServerTransactionStateProceeding;
import net.sourceforge.peers.sip.transaction.NonInviteServerTransactionStateTerminated;
import net.sourceforge.peers.sip.transaction.NonInviteServerTransactionStateTrying;
import net.sourceforge.peers.sip.transaction.NonInviteTransaction;
import net.sourceforge.peers.sip.transaction.ServerTransaction;
import net.sourceforge.peers.sip.transaction.ServerTransactionUser;
import net.sourceforge.peers.sip.transaction.TransactionManager;
import net.sourceforge.peers.sip.transport.SipRequest;
import net.sourceforge.peers.sip.transport.SipResponse;
import net.sourceforge.peers.sip.transport.TransportManager;

public class NonInviteServerTransaction
extends NonInviteTransaction
implements ServerTransaction {
    public final NonInviteServerTransactionState TRYING;
    public final NonInviteServerTransactionState PROCEEDING;
    public final NonInviteServerTransactionState COMPLETED;
    public final NonInviteServerTransactionState TERMINATED;
    protected ServerTransactionUser serverTransactionUser;
    protected Timer timer;
    protected String transport;
    private NonInviteServerTransactionState state;

    NonInviteServerTransaction(String branchId, int port, String transport, String method, ServerTransactionUser serverTransactionUser, SipRequest sipRequest, Timer timer, TransportManager transportManager, TransactionManager transactionManager, Logger logger) {
        super(branchId, method, timer, transportManager, transactionManager, logger);
        this.state = this.TRYING = new NonInviteServerTransactionStateTrying(this.getId(), this, logger);
        this.PROCEEDING = new NonInviteServerTransactionStateProceeding(this.getId(), this, logger);
        this.COMPLETED = new NonInviteServerTransactionStateCompleted(this.getId(), this, logger);
        this.TERMINATED = new NonInviteServerTransactionStateTerminated(this.getId(), this, logger);
        this.transport = transport;
        this.serverTransactionUser = serverTransactionUser;
        this.request = sipRequest;
        try {
            transportManager.createServerTransport(transport, port);
        }
        catch (IOException e) {
            logger.error("input/output error", e);
        }
    }

    public void setState(NonInviteServerTransactionState state) {
        this.state.log(state);
        this.state = state;
    }

    @Override
    public void receivedRequest(SipRequest sipRequest) {
        this.state.receivedRequest();
    }

    @Override
    public void sendReponse(SipResponse sipResponse) {
        this.responses.add(sipResponse);
        int statusCode = sipResponse.getStatusCode();
        if (statusCode < 200) {
            this.state.received1xx();
        } else if (statusCode <= 699) {
            this.state.received200To699();
        }
    }

    void sendLastResponse() {
        int nbOfResponses = this.responses.size();
        if (nbOfResponses > 0) {
            try {
                this.transportManager.sendResponse((SipResponse)this.responses.get(nbOfResponses - 1));
            }
            catch (IOException e) {
                this.logger.error("input/output error", e);
            }
        }
    }

    @Override
    public void start() {
    }

    class TimerJ
    extends TimerTask {
        TimerJ() {
        }

        @Override
        public void run() {
            NonInviteServerTransaction.this.state.timerJFires();
        }
    }
}

